import {useState} from 'react'
import 'bulma/css/bulma.min.css'
import {Container,} from 'react-bulma-components'
import FirstLetterInWord from './FirstLetterInWord'
import PreviousWords from './PreviousWords'
import WordModal from './WordModal'

function App() {

    const [currentWord, setCurrentWord] = useState('')
    const [previousWords, setPreviousWords] = useState(new Array<string>)
    const [showWordModal, setShowWordModal] = useState(false)

    const handleNewWord = function(newWord: string) {
        setCurrentWord(newWord)
        setShowWordModal(true)
        setPreviousWords(previousWords.concat([newWord]))
    }
    const handleCloseModal = function() {
        setShowWordModal(false)
    }

    return (
        <Container>
            <FirstLetterInWord onNewWord={handleNewWord}/>
            <PreviousWords show={previousWords.length > 0} words={previousWords}/>
            <WordModal show={showWordModal} word={currentWord} onClose={handleCloseModal}/>
        </Container>
    )
}

export default App
